jQuery(function($){
	
	$("#divResultado").hide();
	
	$("#aCerrarAvisoEstacion").click(function(){
		$("#divAvisosEstacion").hide("fade");
	});
	
	$("#divCriteriosBusqueda").rup_accordion({
		collapsible: true
	});
	
	$("#btnBuscar").button({
		icons:{primary: "ui-icon-search"}
	}).click(function(){		
		if (fncValidarBusqueda()){
			
			blockUI_Cargando();
			
			fncCargarAvisosEstacion();
			
		}
		
	});
	
	$("#btnLimpiar").button({
		icons:{
			primary: "ui-icon-trash"
		}
	}).click(function(){
		$("#FORMULARIO_BUSQUEDA").rup_form("clearForm");
		$("#txtFecha").val(fechaActual);		
	});
	
	//boton que muestra el popup de exportar
	$("#btnMostrarExportar").button({
		icons:{
			primary: "ui-icon-arrowstop-1-s"
		}
	}).click(function(){
		//antes de mostrar el popup de exportar, valido los datos del formulario
		if (fncValidarBusqueda()){
			//abro el popup de exportar
			$( "#detalleExportar" ).rup_dialog( "open" );
		}
				
	});
	
	//popup de edición 
	$("#detalleExportar").rup_dialog({
		autoOpen: false,
		width: 300,
		modal: true,
		resizable: false,
		position: "center",
		type: $.rup.dialog.DIV
	});
	
	//configuro el formulario de exportar
	$("#FORMULARIO_EXPORTAR").attr('action', $.rup.CTX_PATH + 'informe/datosHorarios?R01HNoPortal=true');
	$("#FORMULARIO_EXPORTAR").attr('method', 'POST');
	$("#FORMULARIO_EXPORTAR").attr("target","_blank");
	
	//boton Exportar
	$("#btnExportar").button({
		icons:{
			primary: "ui-icon-arrowstop-1-s"
		}
	}).click(function(){
		
		//vuelco los datos del filtro al formulario de exportar
		
		$("#idEstacion").val($("#cmbEstacion").rup_combo("getRupValue"));
		$("#nombreEstacion").val($("#cmbEstacion").rup_combo("label")); //vuelco tambien el nombre de la estacion para mostrarlo en el informe
		$("#fechaExportar").val($("#txtFecha").val());
		$("#contaminante1").val($("#cmbContaminante1").rup_combo("getRupValue"));
		$("#contaminante2").val($("#cmbContaminante2").rup_combo("getRupValue"));
		
		$("#nombreContaminante1").val($("#cmbContaminante1").rup_combo("label"));
		$("#nombreContaminante2").val($("#cmbContaminante2").rup_combo("label"));
		
		$("#FORMULARIO_EXPORTAR").submit();
		
		$( "#detalleExportar" ).rup_dialog( "close" );
	});
	
	//cargo los avisos generales con el metodo definido en el _layout.js
	cargarAvisosGenerales();
	
	function fncCargarAvisosEstacion(){
		
		$("#lblNomEstacion").text($("#cmbEstacion").rup_combo("label"));		
		
		$("#pAvisosEstacion").html("");
		
		//obtengo la lista de avisos generales
		$.rup_ajax({
			url: $.rup.CTX_PATH+"avisos/estacion/" + $("#cmbEstacion").rup_combo("getRupValue"),
			dataType: 'json',
			type: "GET",
			async: false,
			contentType: 'application/json',		    
			success: function (resultado, ajaxOptions) {
				//si existen avisos para la estación
				if (resultado.length > 0){
					//cargo la lista de avisos generales
					for (var i=0; i<resultado.length; i++){
						
						var div = $(document.createElement("div"));
						$(div).text("- " + resultado[i].textoAviso);
						
						$("#pAvisosEstacion").append($(div));
					}
					
					$("#divAvisosEstacion").show();
				}else{
					//si no hay avisos para la estación, oculto ese bloque
					$("#divAvisosEstacion").hide();
				}
				
				$("#FORMULARIO_BUSQUEDA").submit();
				
			},
			error: function (xhr, ajaxOptions, thrownError) {
				$("#feedbackMensajes").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_cargar_error, "error");
			}
		});
	}
	
	var anchoComboEstacion=$('#divCriteriosBusqueda').width()*0.25;
	
	$("#cmbEstacion").rup_combo({
		source : $.rup.CTX_PATH+"combo/estaciones",
		sourceParam : {
			label:"descripcion", 
			value:"valor"
		},
		width: anchoComboEstacion,
		blank : ""
	});
	
	$("#cmbContaminante1").rup_combo({
		parent : [ "cmbEstacion" ],
		source : $.rup.CTX_PATH+"combo/contaminantes/",
		sourceParam : {
			label:"descripcion", 
			value:"valor"
		},
		width: anchoComboEstacion,
		blank : ""
	});
	
	$("#cmbContaminante2").rup_combo({
		parent : [ "cmbEstacion" ],
		source : $.rup.CTX_PATH+"combo/contaminantes/",
		sourceParam : {
			label:"descripcion", 
			value:"valor"
		},
		width: anchoComboEstacion,
		blank : ""
	});
	
	
	function fncValidarBusqueda(){
		
		var strMensaje = "";
		var strSeparador = "";
		
		if ($("#cmbEstacion").rup_combo("getRupValue") == ""){			
			strMensaje = " - " + $.rup.i18n.app.mensajes.alert.debe_seleccionar_estacion;
			strSeparador = "<br /><br />";			
		}
		
		if ($("#cmbContaminante1").rup_combo("getRupValue") == ""){			
			strMensaje += strSeparador + " - " + $.rup.i18n.app.mensajes.alert.debe_seleccionar_contaminante1;
			strSeparador = "<br /><br />";			
		}
		
		if ($("#cmbContaminante2").rup_combo("getRupValue") == ""){			
			strMensaje += strSeparador + " - " + $.rup.i18n.app.mensajes.alert.debe_seleccionar_contaminante2;
			strSeparador = "<br /><br />";			
		}
		
		if ($("#cmbContaminante1").rup_combo("getRupValue") != "" && $("#cmbContaminante2").rup_combo("getRupValue") != ""){
			if ($("#cmbContaminante1").rup_combo("getRupValue") == $("#cmbContaminante2").rup_combo("getRupValue")){
				strMensaje += strSeparador + " - " + $.rup.i18n.app.mensajes.alert.debe_seleccionar_contaminantes_distintos;
				strSeparador = "<br /><br />";
			}
			
		}
		
		if ($("#txtFecha").rup_date("getDate") == ""){
			strMensaje += strSeparador + " - " + $.rup.i18n.app.mensajes.alert.debe_seleccionar_fecha;
		}else{
			//valido si es una fecha correcta
			var valida = $.rup_validate.checkDate($.rup.i18n.base.rup_validate.format.date,$("#txtFecha").rup_date("getDate"));
			if (!valida){
				//si no es correcta, muestro mensaje de error
				strMensaje += strSeparador + " - " + $.rup.i18n.base.rup_validate.messages.date;
			}
			
		}
		
		if (strMensaje != ""){
			$("#feedbackMensajes").rup_feedback("set", strMensaje, "alert");
			return false;
		}else{
			return true;
		}
		
	}
	
	$("#FORMULARIO_BUSQUEDA").rup_form({
		url:$.rup.CTX_PATH+"datohorario",
		feedback:$("#feedbackMensajes"),
		type: "POST",
		dataType: "json",
		success:function(xhr){
			
			$("#feedbackMensajes").rup_feedback("hide"); //oculto las validaciones.
			
			//$("#divResultado").hide();
			
			$("#divResultado").show();
			
			if (xhr.length > 0){
				
				$("#divCriteriosBusqueda").accordion({
					  active: false
				});
				
				var datosGrafico = new Array();
				var datosYAxis = new Array();
				datosGrafico.length = xhr.length -1;
				datosYAxis.length = xhr.length -1;
				var oposite = false;
				
				for (var i=0; i<xhr.length;i++){
					
					datosGrafico[i] =
						{
							name: xhr[i].contaminante.nombreContaminante,
							data: xhr[i].listaValores,
							tooltip: {
								valueSuffix: ' (' + xhr[i].contaminante.unidadMedida + ')'
							},
							type: "line",
							yAxis: i
						};
					
					datosYAxis[i] = { // Primary yAxis
						labels: {
							format: '{value} ' + xhr[i].contaminante.unidadMedida							
						},
						title: {
							text: xhr[i].contaminante.nombreContaminante
						},
						opposite: oposite
					};
					oposite = true;
				}
				
				//datosGrafico[1].yAxis = 1;
				
				$("#divMensajeNoHayDatos").hide();
				$("#divPlantilla").show();
				
				//dibujo un grafico y una tabla por cada contaminante
				fncCargarGrafico(xhr, datosGrafico, datosYAxis);
				
				
				//defino todos los acordeones que acabo de generar
				$(".acordeonResultado").rup_accordion({
					collapsible: true
				});
				
				
			}else{
				$("#divMensajeNoHayDatos").show();
				$("#divPlantilla").hide();
			}
			
			$.unblockUI();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			$("#feedbackMensajes").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_cargar_error, "error");
			$.unblockUI();
		},
		validate:{
			rules:{
				//"idEstacion":{required:true},
				"fechaDato":{date:true}
			},
			invalidHandler: function () {
				$.unblockUI();
			}
		}
	});
	
	function fncCargarGrafico(datos, datosGrafico, datosYAxis){
		
		var info = datos[0]; //obtengo el primer registro para leer la información de la estacion
		
		var idGrafico = "grafico1";// + datos.contaminante.idContaminante;
		var tituloGrafico = info.nombreEstacion;
		var subtituloGrafico = info.fechaDato + " - " +  $.rup.i18n.app.graficos.horasGMT;
		
		var plantilla = $("#divPlantilla");
		$(plantilla).find(".tituloAcordeon").text(info.nombreEstacion);
		
		//tabla
		var idTabla = "tabla1";// + datos.contaminante.idContaminante;
		$(plantilla).find(".tblDatos").attr("id",idTabla);
		
		//grafico
		$(plantilla).find(".divGrafico").attr("id",idGrafico);
		$(plantilla).find(".divGrafico").css("width",$('#divCriteriosBusqueda').width()*0.94);
		
		$(plantilla).find(".cambiarGrafico").data("grafico",idGrafico);
		$(plantilla).find(".cambiarGrafico").data("titulo",tituloGrafico);
		$(plantilla).find(".cambiarGrafico").data("subtitulo",subtituloGrafico);
		$(plantilla).find(".cambiarGrafico").data("datos",datosGrafico);
		$(plantilla).find(".cambiarGrafico").data("datosYAxis",datosYAxis);
		
		$(plantilla).find(".cambiarGrafico").change(function(){
			
			var idGrafico = $(this).data("grafico");
			var titulo = $(this).data("titulo");
			var subtitulo = $(this).data("subtitulo");
			var datos = $(this).data("datos");
			var YAxis = $(this).data("datosYAxis");
			
			//actualizo el tipo de grafico en los datos
			for (var i=0;i<datos.length;i++){
				datos[i].type = $(this).val();
			}
			
			cargarGraficoHoras(idGrafico, titulo, subtitulo, datos, YAxis);
		});
		
		//cargo el gráfico
		cargarGraficoHoras(idGrafico, tituloGrafico, subtituloGrafico, datosGrafico, datosYAxis);
		
		//cargo la tabla del contaminante
		fncCargarTablaContaminante(idTabla, datos);
		
	}
	
	function cargarGraficoHoras(idCapa, titulo, subtituloGrafico, datosSeries, datosYAxis){
		$("#" + idCapa).highcharts({
			chart: {
				zoomType: 'xy'
			},
			title: {
				text: titulo
			},
			subtitle: {
				text: subtituloGrafico
			},
			xAxis: [{
				categories: ['1', '2', '3', '4', '5', '6', '7','8','9','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24']
			}],
			yAxis: datosYAxis,
			tooltip: {
				shared: true
			},
			legend: {
				layout: 'vertical',
				align: 'left',
				x: 120,
				verticalAlign: 'top',
				y: 20,
				floating: true,
				backgroundColor: '#FFFFFF'
			},
			series: datosSeries,
			plotOptions: {
				line: {
					dataLabels: {
						enabled: false
					},
					enableMouseTracking: true
				}
			}
		});
	}
	
	function fncCargarTablaContaminante(idTabla, info){
		
		$("#" + idTabla).find("tbody").find("tr").remove();
		
		for (var i=0; i<info.length;i++){
			var datos = info[i];
			var objTR = $(document.createElement("tr"));
			
			$(objTR).append(fncGenerarTD(datos.contaminante.nombreContaminante, "left"));
			$(objTR).append(fncGenerarTD(datos.valorHora01));
			$(objTR).append(fncGenerarTD(datos.valorHora02));
			$(objTR).append(fncGenerarTD(datos.valorHora03));
			$(objTR).append(fncGenerarTD(datos.valorHora04));
			$(objTR).append(fncGenerarTD(datos.valorHora05));
			$(objTR).append(fncGenerarTD(datos.valorHora06));
			$(objTR).append(fncGenerarTD(datos.valorHora07));
			$(objTR).append(fncGenerarTD(datos.valorHora08));
			$(objTR).append(fncGenerarTD(datos.valorHora09));
			$(objTR).append(fncGenerarTD(datos.valorHora10));
			$(objTR).append(fncGenerarTD(datos.valorHora11));
			$(objTR).append(fncGenerarTD(datos.valorHora12));
			$(objTR).append(fncGenerarTD(datos.valorHora13));
			$(objTR).append(fncGenerarTD(datos.valorHora14));
			$(objTR).append(fncGenerarTD(datos.valorHora15));
			$(objTR).append(fncGenerarTD(datos.valorHora16));
			$(objTR).append(fncGenerarTD(datos.valorHora17));
			$(objTR).append(fncGenerarTD(datos.valorHora18));
			$(objTR).append(fncGenerarTD(datos.valorHora19));
			$(objTR).append(fncGenerarTD(datos.valorHora20));
			$(objTR).append(fncGenerarTD(datos.valorHora21));
			$(objTR).append(fncGenerarTD(datos.valorHora22));
			$(objTR).append(fncGenerarTD(datos.valorHora23));
			$(objTR).append(fncGenerarTD(datos.valorHora24));
			
			$("#" + idTabla).find("tbody").append(objTR);
		}
	}
	
	function fncGenerarTD(pValor, pAlign){
		var objTD = $(document.createElement("td"));
		$(objTD).text((pValor == null ? "" : pValor));
		if (pAlign){
			$(objTD).attr("align", pAlign);
		}else{
			$(objTD).attr("align", "right");
		}
		
		return $(objTD);
	}
	
	
});